using System;
using System.Collections.Generic;
using System.Linq;
using HIPS.Web.Components.ServiceModel;
using HIPS.Web.Model.AssistedRegistration;
using HIPS.Web.ModelInterface.AssistedRegistration;
using HIPS.Client.Proxy;
using HIPS.CommonSchemas;
using HIPS.PcehrSchemas;

namespace HIPS.Web.Data.Hips
{
    public class PatientWebServiceRepository : IPatientsWithoutPcehrRepository
    {
        private AssistedRegistrationProxy proxy = new AssistedRegistrationProxy("AssistedRegistrationEndPoint");

        public PatientWithoutPcehrResponse ListPatientsWithoutPcehr(string hospitalCodeSystem, string hospitalCode)
        {
            return proxy.ListPatientsWithoutPcehr(hospitalCodeSystem, hospitalCode);
        }

        // TODO: Refactor remove
        public List<ValidatedPatient> GetPatientsWithoutPcehr(string hospitalCodeSystem, List<Model.AssistedRegistration.Sex> sexes)
        {
            return GetPatientsWithoutPcehr(hospitalCodeSystem, null, sexes);
        }

        // TODO: Refactor remove
        public List<ValidatedPatient> GetPatientsWithoutPcehr(string hospitalCodeSystem, string hospitalCode, List<Model.AssistedRegistration.Sex> sexes)
        {
            AssistedRegistrationProxy proxy = new AssistedRegistrationProxy("AssistedRegistrationEndPoint");

            //TODO: support for hospital code only
            PatientWithoutPcehrResponse response = proxy.ListPatientsWithoutPcehr(hospitalCodeSystem, hospitalCode);

            if (response.HipsResponse.Status == HipsResponseIndicator.OK)
            {
                return response.PatientWithoutPcehrList.Select(p => ModelConversions.LoadValidatedPatient(p, sexes, hospitalCodeSystem)).ToList();
            }
            else
            {
                string hipsError = String.Format("{0} : {1}", response.HipsResponse.Status.ToString(), response.HipsResponse.HipsErrorMessage);
                throw new ApplicationException(String.Format("Error received while retrieving patients without PCEHR. ({0})", hipsError)); 
            }
        }

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            if (proxy != null)
            {
                proxy.DisposeSafely();
                proxy = null;
            }
        }
    }
}